package aero.ru.gpn.cci.tzamobile.states.task.fueling.aircraft

import aero.ru.gpn.cci.tzamobile.R
import aero.ru.gpn.cci.tzamobile.states.AbstractViewState
import aero.ru.gpn.cci.tzamobile.utilities.*
import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import kotlinx.android.synthetic.main.layout_print_withdrawal_slip.*
import kotlinx.android.synthetic.main.layout_print_withdrawal_slip.anti_icing_density_check_value_textView
import kotlinx.android.synthetic.main.layout_print_withdrawal_slip.counter_value_check_textView
import kotlinx.android.synthetic.main.layout_print_withdrawal_slip.fueled_fuel_value_check_textView
import kotlinx.android.synthetic.main.layout_print_withdrawal_slip.fueled_fuel_value_kg_check_textView

class ReceiptPrintingState private constructor(context: Context, view: View) :
    AbstractViewState(context, view) {

    companion object {

        @JvmStatic
        fun getInstance(
            context: Context,
            layoutInflater: LayoutInflater,
            container: ViewGroup
        ) = layoutInflater.inflate(R.layout.layout_print_withdrawal_slip, container, false).run {
            invisible()
            ReceiptPrintingState(context, this)
        }
    }

    private var onPrintButtonClick: () -> Unit = {}

    private var isAntiIcingEnabled = false
    private var isKilosMeasurement = true

    init {
        expense_print_linear_layout.setOnClickListener { onPrintButtonClick() }
    }

    override fun setTextFieldsEnable(isEnable: Boolean) {

    }

    fun initState(
        isAntiIcingEnabled: Boolean,
        isKilosMeasurement: Boolean,
        controlCouponNumber: String?,
        fuelBrand: String?,
        fuelTemperature: Double,
        fuelDensity: Double,
        antiIcingPercent: Double?,
        antiIcingDensity: Double?,
        counterValue: Pair<Long, Long>,
        fueledValue: Int,
        fueledMass: Int,
        antiIcingValue: Int?,
        antiIcingMass: Int?
    ) {

        this.isKilosMeasurement = isKilosMeasurement

        this.isAntiIcingEnabled = isAntiIcingEnabled
        showAntiIcingFields()

        setText(
            controlCouponNumber,
            fuelBrand,
            fuelTemperature,
            fuelDensity,
            counterValue,
            fueledValue,
            fueledMass
        )

        if (isAntiIcingEnabled) drawAntiIcingViews(
            antiIcingPercent,
            antiIcingDensity,
            fueledValue,
            fueledMass,
            antiIcingValue,
            antiIcingMass
        )
    }

    fun setPrintButtonOnClick(action: () -> Unit) {
        onPrintButtonClick = action
    }

    private fun showAntiIcingFields() {
        if (isAntiIcingEnabled)
            anti_icing_fluid_expense_group.visible()
        else
            anti_icing_fluid_expense_group.gone()
    }

    private fun setText(
        controlCouponNumber: String?,
        fuelBrand: String?,
        fuelTemperature: Double,
        fuelDensity: Double,
        counterValue: Pair<Long, Long>,
        fueledValue: Int,
        fueledMass: Int
    ) {
        val dash = context.getString(R.string.dash)

        checkCouponNumberTextView.text = controlCouponNumber ?: dash
        fuel_brand_value_textView.text = fuelBrand ?: dash
        fuel_temp_value_textView.text =
            context.getString(R.string.temperature_totals, fuelTemperature.simpleFormat)
        fuel_density_value_textView.text =
            context.getString(R.string.density_totals, fuelDensity.decimalFormat)

        if (isKilosMeasurement) {
            counter_value_check_textView.text =
                context.getString(R.string.totals_kilos, counterValue.second.simpleFormat)

            fueled_fuel_value_check_textView.text =
                context.getString(R.string.totals_kilos, fueledMass.simpleFormat)
            fueled_fuel_value_kg_check_textView.text =
                context.getString(R.string.totals_litres_bracers, fueledValue.simpleFormat)
        } else {
            counter_value_check_textView.text =
                context.getString(R.string.totals_litres, counterValue.first.simpleFormat)

            fueled_fuel_value_check_textView.text =
                context.getString(R.string.totals_litres, fueledValue.simpleFormat)
            fueled_fuel_value_kg_check_textView.text =
                context.getString(R.string.totals_kilos_bracers, fueledMass.simpleFormat)
        }
    }

    private fun drawAntiIcingViews(
        antiIcingPercent: Double?,
        antiIcingDensity: Double?,
        fueledValue: Int,
        fueledMass: Int,
        antiIcingValue: Int?,
        antiIcingMass: Int?
    ) {

        anti_icing_percent_value_textView.text = context.getString(
            R.string.percent_value,
            antiIcingPercent?.doubleZeroesDecimalFormat
        )
        anti_icing_density_check_value_textView.text =
            context.getString(R.string.density_totals, antiIcingDensity?.decimalFormat)

        if (isKilosMeasurement) {

            fueling_tota_valuel_check_textView.text = context.getString(
                R.string.totals_kilos,
                (fueledMass + (antiIcingMass ?: 0)).simpleFormat
            )
            fueling_tota_value_kg_check_textView.text = context.getString(
                R.string.totals_litres_bracers,
                (fueledValue + (antiIcingValue ?: 0)).simpleFormat
            )

            anti_icing_fluid_value.text =
                context.getString(R.string.totals_kilos, antiIcingMass?.simpleFormat)
            anti_icing_fluid_value_kg.text =
                context.getString(R.string.totals_litres_bracers, antiIcingValue?.simpleFormat)

        } else {

            fueling_tota_valuel_check_textView.text = context.getString(
                R.string.totals_litres,
                (fueledValue + (antiIcingValue ?: 0)).simpleFormat
            )
            fueling_tota_value_kg_check_textView.text = context.getString(
                R.string.totals_kilos_bracers,
                (fueledMass + (antiIcingMass ?: 0)).simpleFormat
            )

            anti_icing_fluid_value.text =
                context.getString(R.string.totals_litres, antiIcingValue?.simpleFormat)
            anti_icing_fluid_value_kg.text =
                context.getString(R.string.totals_kilos_bracers, antiIcingMass?.simpleFormat)
        }

    }
}